
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('main::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('main::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="customers_notifications_pattern"><?php echo e(__('main::lang.pattern')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <select name="customers_notifications_pattern" id="customers_notifications_pattern" class="form-control select2 <?php echo e($errors->first('customers_notifications_pattern') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('main::lang.pattern')); ?>">
                  <option value="push" selected><?php echo e(__('main::lang.push')); ?></option>
                  <option value="in_app"><?php echo e(__('main::lang.in_app')); ?></option>
                </select>
                <?php if($errors->first('customers_notifications_pattern')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_pattern')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="customers_notifications_action"><?php echo e(__('main::lang.action_type')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <select name="customers_notifications_action" id="customers_notifications_action" class="form-control select2 <?php echo e($errors->first('customers_notifications_action') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('main::lang.action_type')); ?>">
                  <option value="url" selected><?php echo e(__('main::lang.url')); ?></option>
                  <option value="deep_link"><?php echo e(__('main::lang.deep_link')); ?></option>
                </select>
                <?php if($errors->first('customers_notifications_action')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_action')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row" id="action_url">
              <label class="col-md-2 col-form-label" for="customers_notifications_action_value"><?php echo e(__('main::lang.url')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <input class="form-control <?php echo e($errors->first('customers_notifications_action_value') ? 'is-invalid' : ''); ?>" id="customers_notifications_action_value" type="text" name="customers_notifications_action_value"
                placeholder="<?php echo e(__('main::lang.url')); ?>" value="<?php echo e(old('customers_notifications_action_value')); ?>">
                <?php if($errors->first('customers_notifications_action_value')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_action_value')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row d-none" id="action_deep_link">
              <label class="col-md-2 col-form-label" for="stores_id"><?php echo e(__('main::lang.store')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <?php echo Form::select('stores_id', $stores,  null, ['class' =>  $errors->first('stores_id') ? 'is-invalid form-control select2' : 'form-control select2','placeholder'=>__('main::lang.store'),'id'=>'stores_id']); ?>

                <?php if($errors->first('stores_id')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('stores_id')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="customers_notifications_type"><?php echo e(__('main::lang.type')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <select class="form-control select2 <?php echo e($errors->first('customers_notifications_type') ? 'is-invalid' : ''); ?>" name="customers_notifications_type" id="choose_type" placeholder="<?php echo e(__('main::lang.type')); ?>" >
                  <option value="all" selected><?php echo e(__('main::lang.allCustomers')); ?></option>
                  <option value="some"><?php echo e(__('main::lang.someCustomers')); ?></option>
                  <option value="country"><?php echo e(__('main::lang.country')); ?></option>
                  <option value="gender"><?php echo e(__('main::lang.gender')); ?></option>
                </select> 
                <?php if($errors->first('customers_notifications_type')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_type')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row allCustomers  d-none">
              <label class="col-md-2 col-form-label" for="customers_notifications_customers"><?php echo e(__('main::lang.customers')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10 ">
                <?php echo e(Form::select('customers_notifications_customers[]',$customers,old('customers_notifications_customers'),["class"=>"form-control js-states","multiple"=>"multiple","id"=>"customers_notifications_customers" ])); ?>

                <?php if($errors->first('customers_notifications_customers')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_customers')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row countries_div  d-none">
              <label class="col-md-2 col-form-label" for="countries_id"><?php echo e(__('main::lang.country')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10 ">
                <?php echo e(Form::select('countries_id',$countries,old('countries_id'),["class"=>"form-control js-states","id"=>"countries_id",'placeholder'=>__('main::lang.country') ])); ?>

                <?php if($errors->first('countries_id')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('countries_id')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row gender_div  d-none">
              <label class="col-md-2 col-form-label" for="customers_gender"><?php echo e(__('main::lang.gender')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10 ">
                <?php echo e(Form::select('customers_gender',['male'=>__('main::lang.male'),'female'=>__('main::lang.female')],old('customers_gender'),["class"=>"form-control js-states","id"=>"customers_gender",'placeholder'=>__('main::lang.gender') ])); ?>

                <?php if($errors->first('customers_gender')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('customers_gender')); ?></div>
                <?php endif; ?>
              </div>
            </div>
 
            <div class="form-group row ">
              <label class="col-md-2 col-form-label" for="customers_notifications_image"><?php echo e(__('main::lang.img')); ?><span class="text-danger">  </span></label>
              <div class="col-md-10">
                <?php echo $__env->make('main::layouts.includes.imagePreview', ['name' => 'customers_notifications_image', 'value' => null,'type'=>'notifications'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($errors->first('customers_notifications_image')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_image')); ?></div>
                <?php endif; ?>
              </div>
            </div>

 
        </div>
      </div>
    </div>


    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.currencyDetails')); ?></p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.title')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control character-title <?php echo e($errors->first('customers_notifications_title_'.$lang->locale) ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e('customers_notifications_title_'.$lang->locale); ?>" placeholder="<?php echo e(__('main::lang.title')); ?>"
                 value="<?php echo e(old('customers_notifications_title_'.$lang->locale)); ?>">
                <?php if($errors->first('customers_notifications_title_'.$lang->locale)): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_title_'.$lang->locale)); ?></div>
                <?php endif; ?>
              </div>
              <span class="character-count"><?php echo e(__('main::lang.remainingChar')); ?> : 35</span>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.text')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control character-desc  <?php echo e($errors->first('customers_notifications_text_'.$lang->locale) ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e('customers_notifications_text_'.$lang->locale); ?>" placeholder="<?php echo e(__('main::lang.text')); ?>"
                 value="<?php echo e(old('customers_notifications_text_'.$lang->locale)); ?>">
                <?php if($errors->first('customers_notifications_text_'.$lang->locale)): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('customers_notifications_text_'.$lang->locale)); ?></div>
                <?php endif; ?>
              </div>
              <span class="character-count"><?php echo e(__('main::lang.remainingChar')); ?> : 70</span>
            </div>

          </div>

        </div>


      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


  </div>
</div>
<?php $__env->startSection('script'); ?>
<script>
	$('#choose_type').change(function() {
		value = $('#choose_type').val() ;
    $('.allCustomers').addClass('d-none');
    $('.countries_div').addClass('d-none');
    $('.gender_div').addClass('d-none');
		if(value == 'some'){
			$('.allCustomers').removeClass('d-none');
		}else if(value == 'country'){
			$('.countries_div').removeClass('d-none');
		}else if(value == 'gender'){
			$('.gender_div').removeClass('d-none');
		}
	})

	$('#customers_notifications_action').change(function() {
		action = $('#customers_notifications_action').val() ;
		if(action == 'url'){
			$('#action_url').removeClass('d-none');
			$('#action_deep_link').addClass('d-none');

		}else{
			$('#action_deep_link').removeClass('d-none');
			$('#action_url').addClass('d-none');
		}
	})

  $("#customers_notifications_customers").select2({
      placeholder: "Select a customers"
  });


  $('.character-title').on('keydown keyup', function(e){
      var total = 35;
      var value = $(this).val();
      var remaining = total - value.length;
      if(remaining == 0 && e.keyCode != 46 && e.keyCode != 8)  // 46 => delete, 8 => backspace
      {
          e.preventDefault();
      }
      $(this).parent('.col-md-10').siblings('.character-count').text("<?php echo e(__('main::lang.remainingChar')); ?> : "+remaining);

  });
  $('.character-desc').on('keydown keyup', function(e){
      var total = 70;
      var value = $(this).val();
      var remaining = total - value.length;
      if(remaining == 0 && e.keyCode != 46 && e.keyCode != 8)  // 46 => delete, 8 => backspace
      {
          e.preventDefault();
      }
      $(this).parent('.col-md-10').siblings('.character-count').text("<?php echo e(__('main::lang.remainingChar')); ?> : "+remaining);

  });
</script>
<?php $__env->stopSection(); ?><?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/customers_notifications/form.blade.php ENDPATH**/ ?>