
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('main::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('main::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">


            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="stores_code"><?php echo e(__('main::lang.stores_code')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-6">
              <input class="form-control <?php echo e($errors->first('stores_code') ? 'is-invalid' : ''); ?>" id="stores_code" type="text" name="stores_code" placeholder="<?php echo e(__('main::lang.stores_code')); ?>" value="<?php echo e(old('stores_code', isset($store) ? $store->stores_code : '')); ?>">
              <?php if($errors->first('stores_code')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('stores_code')); ?></div>
              <?php endif; ?>
              </div>
            </div>
            
            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="stores_link"><?php echo e(__('main::lang.stores_link')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-6">
                <input class="form-control <?php echo e($errors->first('stores_link') ? 'is-invalid' : ''); ?>" id="stores_link" type="url" name="stores_link" placeholder="<?php echo e(__('main::lang.stores_link')); ?>" value="<?php echo e(old('stores_link', isset($store) ? $store->stores_link : '')); ?>">
                <?php if($errors->first('stores_link')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('stores_link')); ?></div>
                <?php endif; ?>
                </div>
            </div>

            
            <div class="form-group row ">
              <label class="col-md-2 col-form-label" for="stores_logo"><?php echo e(__('main::lang.stores_logo')); ?><span class="text-danger">  </span></label>
              <div class="col-md-10">
                <?php echo $__env->make('main::layouts.includes.imagePreview', ['name' => 'stores_logo', 'value' => isset($store) ? $store->stores_logo : null,'type'=>'stores'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($errors->first('stores_logo')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('stores_logo')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="categories"><?php echo e(__('main::lang.categories')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <?php echo Form::select('categories[]', $categories, isset($store) ? $store->categories : null, ['class' => $errors->first('categories') ? 'form-control is-invalid select2' : 'form-control select2','id'=>'categories','multiple'=>'multiple']); ?>

                <?php if($errors->first('categories')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('categories')); ?></div>
                <?php endif; ?>
              </div>
            </div>
  
            <div class="form-group row">
              <label class="col-md-2 col-form-label" for="countries"><?php echo e(__('main::lang.countries')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10">
                <?php echo Form::select('countries[]', $countries, isset($store) ? $store->countries : null, ['class' => $errors->first('offers_id') ? 'form-control is-invalid select2' : 'form-control select2','id'=>'countries','multiple'=>'multiple']); ?>

                <?php if($errors->first('offers_id')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('countries')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="stores_position"><?php echo e(__('main::lang.position')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-3">
                <input class="form-control <?php echo e($errors->first('stores_position') ? 'is-invalid' : ''); ?>" id="stores_position" type="text" name="stores_position"
                placeholder="<?php echo e(__('main::lang.position')); ?>" value="<?php echo e(old('stores_position', isset($store) ? $store->stores_position : 1)); ?>">
                <?php if($errors->first('stores_position')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('stores_position')); ?></div>
                <?php endif; ?>
                </div>
            </div>

            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.is_special')); ?><span class="text-danger"> *</span></label>
              <div class="col-md-10 col-form-label">
                <?php
                  $is_special = old('stores_is_special', isset($store) ? $store->stores_is_special : 1);
                ?>
                <input type="hidden" id="stores_is_special_input" name="stores_is_special" value="<?php echo e($is_special); ?>">
                <input type="checkbox" name="stores_is_specials" id="stores_is_special"  <?php echo e($is_special ? 'checked' : ''); ?>  data-on=" <?php echo e(__('main::lang.special')); ?>" data-off=" <?php echo e(__('main::lang.not_special')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="150px" onChange="changeToggleInput('stores_is_special')">
  
                <?php if($errors->first('stores_is_special')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first('stores_is_special')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.status')); ?><span class="text-danger"> *</span></label>
                <div class="col-md-6 col-form-label">
                    <?php
                    $status = old('stores_status', isset($store) ? $store->stores_status : 1);
                    ?>

                    <input type="hidden" id="stores_status_input" name="stores_status" value="<?php echo e($status); ?>">
                    <input type="checkbox" name="stores_statuss" id="stores_status"  <?php echo e($status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('general::lang.active')); ?>" data-off=" <?php echo e(__('general::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="80px" onChange="changeStatusInput('stores')">

                <?php if($errors->first('stores_status')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first('stores_status')); ?></div>
                <?php endif; ?>
                </div>
            </div>


        </div>
      </div>
    </div>


    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('main::lang.storeDetails')); ?></p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.stores_name')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-6">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.stores_name') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[stores_name]'); ?>" placeholder="<?php echo e(__('main::lang.stores_name')); ?>"
                 value="<?php echo e(old($lang->locale .'.stores_name', isset($store) && $store->translate($lang->locale)  ? $store->translate($lang->locale)->stores_name : '')); ?>">
                <?php if($errors->first($lang->locale .'.stores_name')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.stores_name')); ?></div>
                <?php endif; ?>
              </div>
            </div>
         
            <div class="form-group row">
                <label class="col-md-2 col-form-label"><?php echo e(__('main::lang.stores_desc')); ?><span class="text-danger"></span></label>

                <div class="col-md-10">
                  <textarea id="<?php echo e($lang->locale); ?>-ckeditor" class="ckeditor form-control <?php echo e($errors->first($lang->locale .'.stores_desc') ? 'is-invalid' : ''); ?>" type="text" rows="5" name="<?php echo e($lang->locale .'[stores_desc]'); ?>" placeholder="<?php echo e(__('main::lang.stores_desc')); ?>"><?php echo e(old($lang->locale .'.stores_desc', isset($store) && $store->translate($lang->locale)  ? $store->translate($lang->locale)->stores_desc : '')); ?></textarea>
                  <?php if($errors->first($lang->locale .'.stores_desc')): ?>
                    <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.stores_desc')); ?></div>
                  <?php endif; ?>
                </div>
            </div>

          </div>

        </div>



      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


  </div>
</div>
<?php /**PATH /home2/trainopi/public_html/system-primocoupon-com/system/Modules/Main/Resources/views/admin/stores/form.blade.php ENDPATH**/ ?>