
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>
<div class="card-body">
	<?php echo $__env->make('general::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-lg-9">
        <input type="hidden" name="faqs_type" value="website">
         
        <ul class="nav nav-tabs" id="langsTabs" role="tablist">
          <li class="nav-item">
            <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
            <?php echo e(__('general::lang.general')); ?></a>
          </li>
          <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="nav-item">
              <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
                role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
                <?php echo e(__('general::lang.'. $lang->locale)); ?>

              </a>
            </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        
        <div class="tab-content" id="langsTabsContent">
          <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
            <div class="row">
              <div class="col-lg-9">
         
                 <!-- position field  -->
                <div class="form-group row">
                    <label class="col-md-3 col-form-label" for="faqs_position"><?php echo e(__('general::lang.position')); ?><span class="text-danger"> *</span></label>
                    <div class="col-md-6">
                    <input class="form-control <?php echo e($errors->first('faqs_position') ? 'is-invalid' : ''); ?>" id="faqs_position" type="text" name="faqs_position"
                    placeholder="<?php echo e(__('general::lang.position')); ?>" value="<?php echo e(old('faqs_position', isset($faq) ? $faq->faqs_position : 10000)); ?>">
                    <?php if($errors->first('faqs_position')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('faqs_position')); ?></div>
                    <?php endif; ?>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-3 col-form-label"><?php echo e(__('general::lang.status')); ?><span class="text-danger"> *</span></label>
                    <div class="col-md-9 col-form-label">
                      <?php
                        $status = old('faqs_status', isset($faq) ? $faq->faqs_status : 1);
                      ?>
                       <input type="hidden" id="faqs_status_input" name="faqs_status" value="<?php echo e($status); ?>">
                       <input type="checkbox" name="faqs_statuss" id="faqs_status"  <?php echo e($status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('general::lang.active')); ?>" data-off=" <?php echo e(__('general::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-width="80px" onChange="changeStatusInput('faqs')">
                      <?php if($errors->first('faqs_status')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first('faqs_status')); ?></div>
                      <?php endif; ?>
                    </div>
                  </div>


              </div>
            </div>
          </div>

            
            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

                <div class="form-group row">
                    <label class="col-md-2 col-form-label" for="faqs_question"><?php echo e(__('general::lang.faqs_question')); ?><span class="text-danger">*</span></label>
                    <div class="col-md-10">
                      <input class="form-control <?php echo e($errors->first($lang->locale .'.faqs_question') ? 'is-invalid' : ''); ?>" id="faqs_question" type="text" name="<?php echo e($lang->locale .'[faqs_question]'); ?>" placeholder="<?php echo e(__('general::lang.faqs_question')); ?>"
                       value="<?php echo e(old($lang->locale .'.faqs_question', isset($faq) ? $faq->translate($lang->locale)->faqs_question : '')); ?>">
                      <?php if($errors->first($lang->locale .'.faqs_question')): ?>
                        <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.faqs_question')); ?></div>
                      <?php endif; ?>
                    </div>
                </div>

                <div class="form-group row">
                  <label class="col-md-2 col-form-label"><?php echo e(__('general::lang.faqs_answer')); ?><span class="text-danger"> *</span></label>
                  <div class="col-md-10">
                    <textarea id="<?php echo e($lang->locale); ?>-ckeditor" class="form-control ckeditor <?php echo e($errors->first($lang->locale .'.faqs_answer') ? 'is-invalid' : ''); ?>"
                     name="<?php echo e($lang->locale .'[faqs_answer]'); ?>" rows="9" placeholder="<?php echo e(__('general::lang.faqs_answer')); ?>"
                     ><?php echo e(old($lang->locale .'.faqs_answer', isset($faq) && $faq->translate($lang->locale) ? $faq->translate($lang->locale)->faqs_answer : '')); ?></textarea>
                    <?php if($errors->first($lang->locale .'.faqs_answer')): ?>
                      <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.faqs_answer')); ?></div>
                    <?php endif; ?>
                  </div>
                </div>

            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>


    </div>
  </div>
</div>
 <?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/General/Resources/views/admin/faqs/form.blade.php ENDPATH**/ ?>