
<?php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
?>

<div class="card-body">
  <?php echo $__env->make('general::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link <?php echo e($activeLocale == 'general' ? 'active' : ''); ?>" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      <?php echo e(__('general::lang.general')); ?></a>
    </li>
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="nav-item">
        <a class="nav-link <?php echo e($activeLocale == $lang->locale ? 'active' : ''); ?>" id="<?php echo e($lang->locale); ?>-tab" data-toggle="tab" href="#<?php echo e($lang->locale); ?>"
          role="tab" aria-controls="<?php echo e($lang->locale); ?>" aria-selected="false">
          <?php echo e(__('general::lang.'. $lang->locale)); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

  
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade <?php echo e($activeLocale == 'general' ? 'show active' : ''); ?>" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-4">

          <div class="form-group row" >
            <label class="col-md-3 col-form-label" for="contacts_mobiles"><?php echo e(__('general::lang.mobiles')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
                <div class="input-group ltr" dir="ltr">
                    <input class="form-control <?php echo e($errors->first('contacts_mobiles') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_mobiles" type="text" name="contacts_mobiles" placeholder="<?php echo e(__('general::lang.mobiles')); ?>" value="<?php echo e(old('contacts_mobiles', isset($contact) ? $contact->contacts_mobiles : 1)); ?>">
                    <div class="input-group-prepend">
                      <span class="input-group-text" dir="ltr">+<?php echo e(env('country_code',90)); ?></span>
                    </div>
                </div>
              <?php if($errors->first('contacts_mobiles')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_mobiles')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_email"><?php echo e(__('general::lang.email')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('contacts_email') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_email" type="email" name="contacts_email"
               placeholder="<?php echo e(__('general::lang.email')); ?>" value="<?php echo e(old('contacts_email', isset($contact) ? $contact->contacts_email : 1)); ?>">
              <?php if($errors->first('contacts_email')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_email')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_facebook"><?php echo e(__('general::lang.facebook')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('contacts_facebook') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_facebook" type="text" name="contacts_facebook"
               placeholder="<?php echo e(__('general::lang.facebook')); ?>" value="<?php echo e(old('contacts_facebook', isset($contact) ? $contact->contacts_facebook : 1)); ?>">
              <?php if($errors->first('contacts_facebook')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_facebook')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_twitter"><?php echo e(__('general::lang.twitter')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('contacts_twitter') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_twitter" type="text" name="contacts_twitter"
               placeholder="<?php echo e(__('general::lang.twitter')); ?>" value="<?php echo e(old('contacts_twitter', isset($contact) ? $contact->contacts_twitter : 1)); ?>">
              <?php if($errors->first('contacts_twitter')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_twitter')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_instagram"><?php echo e(__('general::lang.instagram')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('contacts_instagram') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_instagram" type="text" name="contacts_instagram"
               placeholder="<?php echo e(__('general::lang.instagram')); ?>" value="<?php echo e(old('contacts_instagram', isset($contact) ? $contact->contacts_instagram : 1)); ?>">
              <?php if($errors->first('contacts_instagram')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_instagram')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_snapchat"><?php echo e(__('general::lang.snapchat')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('contacts_snapchat') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_snapchat" type="text" name="contacts_snapchat"
               placeholder="<?php echo e(__('general::lang.snapchat')); ?>" value="<?php echo e(old('contacts_snapchat', isset($contact) ? $contact->contacts_snapchat : 1)); ?>">
              <?php if($errors->first('contacts_snapchat')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_snapchat')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_youtube"><?php echo e(__('general::lang.youtube')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('contacts_youtube') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_youtube" type="text" name="contacts_youtube"
               placeholder="<?php echo e(__('general::lang.youtube')); ?>" value="<?php echo e(old('contacts_youtube', isset($contact) ? $contact->contacts_youtube : 1)); ?>">
              <?php if($errors->first('contacts_youtube')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_youtube')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_tiktok"><?php echo e(__('general::lang.tiktok')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
              <input class="form-control <?php echo e($errors->first('contacts_tiktok') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_tiktok" type="text" name="contacts_tiktok"
               placeholder="<?php echo e(__('general::lang.tiktok')); ?>" value="<?php echo e(old('contacts_tiktok', isset($contact) ? $contact->contacts_tiktok : 1)); ?>">
              <?php if($errors->first('contacts_tiktok')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_tiktok')); ?></div>
              <?php endif; ?>
            </div>
          </div>

          <div class="form-group row">
            <label class="col-md-3 col-form-label" for="contacts_whatsapp"><?php echo e(__('general::lang.whatsapp')); ?><span class="text-danger"> </span></label>
            <div class="col-md-9">
                <div class="input-group mb-3">
                    <input class="form-control <?php echo e($errors->first('contacts_whatsapp') ? 'is-invalid' : ''); ?>" dir="ltr" id="contacts_whatsapp" type="text" name="contacts_whatsapp" placeholder="<?php echo e(__('general::lang.whatsapp')); ?>" value="<?php echo e(old('contacts_whatsapp', isset($contact) ? $contact->contacts_whatsapp : 1)); ?>">
                    <div class="input-group-prepend">
                      <span class="input-group-text" dir="ltr">+<?php echo e(env('country_code',90)); ?></span>
                    </div>
                </div>

              <?php if($errors->first('contacts_whatsapp')): ?>
                <div class="invalid-feedback"><?php echo e($errors->first('contacts_whatsapp')); ?></div>
              <?php endif; ?>
            </div>
          </div>





        </div>
      </div>
    </div>
    
    <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="tab-pane fade <?php echo e($activeLocale == $lang->locale ? 'show active' : ''); ?>" id="<?php echo e($lang->locale); ?>" role="tabpanel" aria-labelledby="<?php echo e($lang->locale); ?>-tab">

        <div class="row">
          <div class="col-lg-9">
            <p class="text-primary h6"><?php echo e(__('general::lang.address')); ?></p>

            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('general::lang.address')); ?><span class="text-danger">  </span></label>

              <div class="col-md-9">
                <input class="form-control <?php echo e($errors->first($lang->locale .'.contacts_address') ? 'is-invalid' : ''); ?>" type="text"
                 name="<?php echo e($lang->locale .'[contacts_address]'); ?>" placeholder="<?php echo e(__('general::lang.address')); ?>"
                 value="<?php echo e(old($lang->locale .'.contacts_address', isset($contact) && $contact->translate($lang->locale) ? $contact->translate($lang->locale)->contacts_address : '')); ?>">
                <?php if($errors->first($lang->locale .'.contacts_address')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.contacts_address')); ?></div>
                <?php endif; ?>
              </div>
            </div>

            <div class="form-group row">
              <label class="col-md-3 col-form-label"><?php echo e(__('general::lang.desc')); ?><span class="text-danger"> *</span></label>

              <div class="col-md-9">
                <textarea id="<?php echo e($lang->locale); ?>-ckeditor" class="form-control ckeditor <?php echo e($errors->first($lang->locale .'.contacts_text') ? 'is-invalid' : ''); ?>"
                  name="<?php echo e($lang->locale .'[contacts_text]'); ?>" rows="9" placeholder="<?php echo e(__('general::lang.desc')); ?>"
                  ><?php echo e(old($lang->locale .'.contacts_text', isset($contact) && $contact->translate($lang->locale) ? $contact->translate($lang->locale)->contacts_text : '')); ?></textarea>
                <?php if($errors->first($lang->locale .'.contacts_text')): ?>
                  <div class="invalid-feedback"><?php echo e($errors->first($lang->locale .'.contacts_text')); ?></div>
                <?php endif; ?>
              </div>


            </div>

          </div>
        </div>




      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</div>
<?php /**PATH /home2/trainopi/public_html/system-primocoupon-com/system/Modules/General/Resources/views/admin/contacts/form.blade.php ENDPATH**/ ?>