<!DOCTYPE html>


<html dir="<?php echo e($dir); ?>" lang="<?php echo e($locale); ?>" class="<?php echo e($dir == 'rtl' ? 'fa-dir-flip' : ''); ?>">
<head>
    <base href="./">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="keyword" content="Admin, Control Panel">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(__('general::lang.siteTitle')); ?> | <?php echo e(__('general::lang.adminPanel')); ?></title>

    <link rel="icon" href="<?php echo e(asset('assets/adminPanel/img/logo-icon.png')); ?>" type="image/png" sizes="16x16">

    
    <?php if($dir == 'rtl'): ?>
        
        
    <?php endif; ?>
    <!-- Icons-->
    <link href="<?php echo e(asset('assets/adminPanel/vendors/@coreui/icons/css/coreui-icons.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/vendors/flag-icon-css/css/flag-icon.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/vendors/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/vendors/simple-line-icons/css/simple-line-icons.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/vendors/select2/css/select2.min.css')); ?>" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/5.0.1/css/fileinput.min.css" media="all" rel="stylesheet" type="text/css" />
    

    <!-- Styles for File Input Plugin-->
    <link href="<?php echo e(asset('assets/adminPanel/css/file-input/fileinput.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/css/file-input/fileinput-rtl.css')); ?>" rel="stylesheet">

    
    <?php if($dir == 'rtl'): ?>
    <!-- CSS -->
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.11.2/build/css/alertify.rtl.min.css"/>
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.11.2/build/css/themes/bootstrap.rtl.min.css"/>

    <?php else: ?>
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.11.2/build/css/alertify.min.css"/>
    <!-- Bootstrap theme -->
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/alertifyjs@1.11.2/build/css/themes/bootstrap.min.css"/>
    <?php endif; ?>
    

    
    <script src="<?php echo e(asset('assets/adminPanel/js/pusher.min.js')); ?>"></script>
    <script>
        /**
        * Plays a sound using the HTML5 audio tag. Provide mp3 and ogg files for best browser support.
        */
        function playSound(){

            var mp3Source = '<source src="<?php echo e(asset('sounds/inflicted-mp.mp3')); ?>" type="audio/mpeg">';
            var oggSource = '<source src="<?php echo e(asset('sounds/inflicted-og.ogg')); ?>" type="audio/ogg">';
            var embedSource = '<embed hidden="true" autostart="true" loop="false" src="<?php echo e(asset('sounds/inflicted-mp.mp3')); ?>">';
            document.getElementById("sound").innerHTML='<audio id="notificationSound" autoplay="autoplay" loop>' + mp3Source + oggSource + embedSource + '</audio>';

        }
    </script>
    <!-- Main styles for this application-->
    <link href="<?php echo e(asset('assets/adminPanel/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/vendors/pace-progress/css/pace.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/css/tajawal-font.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/adminPanel/css/custom.css')); ?>" rel="stylesheet">

    <!-- Styles for bootstrap4-toggle-->
    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldContent('style'); ?>

</head>
<body class="app header-fixed sidebar-hidden aside-menu-fixed">
    <?php echo $__env->make('general::layouts.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div id="overlayer"></div>

    <div class="row">
        <div class="col">
            <div class="text-center">
                <div class="loader">
                  <span class="loader-inner"> </span>
                </div>
            </div>
        </div>
    </div>

    <div id="sound"></div>
    <div class="app-body">
        <?php echo $__env->make('general::layouts.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('main'); ?>
    </div>
    <?php echo $__env->make('general::layouts.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('general::layouts.includes.generalModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- CoreUI and necessary plugins-->
    <script src="<?php echo e(asset('assets/adminPanel/vendors/jquery/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/vendors/popper.js/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/vendors/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/vendors/pace-progress/js/pace.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/vendors/perfect-scrollbar/js/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/vendors/@coreui/coreui/js/coreui.min.js')); ?>"></script>
     <!-- <script src="<?php echo e(asset('assets/adminPanel/vendors/ckeditor/ckeditor.js')); ?>"></script> -->
     <!-- <script src="https://cdn.ckeditor.com/4.13.1/full/ckeditor.js"></script> -->
    <script src="//cdn.ckeditor.com/4.11.4/full/ckeditor.js"></script>
    <script src="<?php echo e(asset('assets/adminPanel/vendors/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/vendors/select2/js/i18n/ar.js')); ?>"></script>
    

    <!-- Custom scripts required by this view -->

    <!-- JS for File Input Plugin-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/5.0.1/js/plugins/piexif.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/adminPanel/js/file-input/fileinput.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/js/file-input/themes/theme.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/adminPanel/js/file-input/ar.js')); ?>"></script>

    

    <script src="//cdn.jsdelivr.net/npm/alertifyjs@1.11.2/build/alertify.min.js"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="<?php echo e(asset('assets/adminPanel/js/custom.js')); ?>"></script>
    <script>
        function copyToClipboard(element) {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(element).text()).select();
            document.execCommand("copy");
            $temp.remove();
        }
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        })

        <?php if(session()->has('status')): ?>
            <?php if(!$agent->isPhone()): ?>
                Toast.fire({
                    icon: 'success',
                    title: "<?php echo e(session('status')); ?>",
                })
            <?php else: ?>
                Swal.fire({
                    title: "<?php echo e(__('lang.SuccessAlert')); ?>",
                    text: "<?php echo e(session('status')); ?>",
                    icon: 'success',
                    confirmButtonText: "<?php echo e(__('general::lang.close')); ?>"
                })
            <?php endif; ?>
        <?php endif; ?>
        <?php if(session()->has('status_danger')): ?>
            <?php if(!$agent->isPhone()): ?>
                Toast.fire({
                    icon: 'error',
                    title: "<?php echo e(session('status_danger')); ?>",
                })
            <?php else: ?>
                Swal.fire({
                    title: "<?php echo e(__('lang.warningAlert')); ?>",
                    text: "<?php echo e(session('status_danger')); ?>",
                    icon: 'error',
                    confirmButtonText: "<?php echo e(__('general::lang.close')); ?>"
                })
            <?php endif; ?>

        <?php endif; ?>
        <?php if(session()->has('success_modal')): ?>
            Swal.fire({
                title: "<?php echo e(session('success_modal')); ?>",
                // text: "<?php echo e(session('success_modal')); ?>",
                icon: 'success',
                confirmButtonText: "<?php echo e(__('general::lang.close')); ?>"
            })
        <?php endif; ?>

        // $( function(){

        //   $('[type=date]').datepicker({
        //         dateFormat: "yy-mm-dd",
        //         changeMonth: true,
        //         changeYear: true,
        //         showButtonPanel: true,
        //         yearRange: "-50:+50",
        //     }).attr('readonly','readonly');
        // });
      // $(".loader").delay(2000).fadeOut("slow");
    //  $("#overlayer").delay(2000).fadeOut("slow");
    //  $(document).ready(function() {
    //     $(".loader").show();
    //     $("#overlayer").show();
    //   });
    //   $(".loader").hide();
    //   $("#overlayer").hide();
    $('.delete-form').click(function(e) {
        e.preventDefault() // Don't post the form, unless confirmed

        alertify.dialog('confirm')
        .set('title', '')
        .set('labels', {ok:"<?php echo e(__('general::lang.ok')); ?>", cancel:"<?php echo e(__('general::lang.cancel')); ?>"})
        .set({transition:'zoom',message: "<?php echo e(__('general::lang.AreYouSure')); ?>"})
        .set('onok', function(closeEvent){
            // Post the form
            $(e.target).closest('form').submit() // Post the surrounding form
        })
        .set('oncancel', function(closeEvent){

        })
        .show();
    });

    </script>
    <script>
        function changeStatus(type,id){

            if(type == 'articles_featured'){
                type = 'articles';
                field = 'articles_featured';
                if(document.getElementById('articles_featured'+id).checked){
                    status = '1';
                }else{
                    status = '0';
                }
            }else{
                field = 'status';
                if(document.getElementById(type+'_status_'+id).checked){
                    status = '1';
                }else{
                    status = '0';
                }
            }
 
            $.ajax({
                type: "GET",
                url: "<?php echo url('/')?>/<?php echo e($locale); ?>/admin/"+type+"/changeStatus/"+id+"/"+status+"?field="+field,
                data: {
                    '_token': $('input[name=_token]').val(),
                    'device_token': "<?php echo e(isset($device_token) ? $device_token : ''); ?>",
                },
                success: function(data) {
                    Swal.fire({
                        title: data.msg,
                        // text: data.msg,
                        icon: 'success',
                        confirmButtonText: "<?php echo e(__('general::lang.close')); ?>"
                    })

                    if(type == 'offers_magazines'){
                        location.reload()
                    }
                }
            })

        }

        function changeStatusInput(type){
            if(document.getElementById(type+'_status').checked){
                $('#'+type+'_status_input').val('1')
            }else{
                $('#'+type+'_status_input').val('0')
            }
        }

        function changeToggleInput(type){
            if(document.getElementById(type).checked){
                $('#'+type+'_input').val('1')
            }else{
                $('#'+type+'_input').val('0')
            }
        }
    </script>
    <!-- JS for bootstrap4-toggle-->
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>


    
    <?php echo $__env->make('general::layouts.includes.ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('js'); ?>
    <?php echo $__env->yieldContent('script'); ?>

</body>
</html>
<?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/General/Resources/views/layouts/master.blade.php ENDPATH**/ ?>