<?php $__env->startSection('main'); ?>
  <main class="main">
  	
    <ol class="breadcrumb">
      <li class="breadcrumb-item"> <a href="<?php echo e(route('admin.dashboard.home')); ?>"><?php echo e(__('main::lang.home')); ?> </a> </li>
      <li class="breadcrumb-item  active"> <?php echo e(__('main::lang.customers')); ?> </li>
     </ol>
	
    <div class="container-fluid">
      <div class="animated fadeIn">
      	<?php echo $__env->make('main::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      	
        <div class="card">
          <div class="card-body">
            <form class="form-horizontal" action="<?php echo e(route('admin.customers.index')); ?>" method="get">
              <div class="row">
           
                <div class="form-group col-12 col-md-2 text-center">
                  <input class="form-control" type="text" name="name" placeholder="<?php echo e(__('main::lang.customers_name')); ?>" value="<?php echo e(old('name')); ?>">
                </div>

                <div class="form-group col-12 col-md-2 text-center">
                    <div class="input-group "  dir="rtl" >
                      <input class="form-control" type="text" dir="ltr" name="phone" placeholder="<?php echo e(__('main::lang.customers_phone')); ?>" value="<?php echo e(old('phone')); ?>">
                      
                    </div>
                </div>

                <div class="form-group col-12 col-md-2 text-center">
                  <?php echo Form::select('country', $countries, null, ['class' =>'form-control','placeholder'=>__('main::lang.country'),'id'=>'country']); ?>

                </div>

                <div class="form-group col-12 col-md-2 text-center">
                    <input class="form-control" type="text" dir="ltr" name="email" placeholder="<?php echo e(__('main::lang.email')); ?>" value="<?php echo e(old('email')); ?>">
                </div>

                <div class="form-group col-12 col-md-1 text-center">
                    <select class="form-control" name="gender">
                        <option value=""><?php echo e(__('main::lang.gender')); ?></option>
                        <option value="male" <?php echo e(old('gender') == 'male' ? 'selected' : ''); ?>><?php echo e(__('main::lang.male')); ?></option>
                        <option value="female" <?php echo e(old('gender') == 'female' ? 'selected' : ''); ?>><?php echo e(__('main::lang.female')); ?></option>
                    </select>
                </div>

                <div class="form-group col-12 col-md-1 text-center">
                    <select class="form-control" name="status">
                        <option value=""><?php echo e(__('main::lang.selectStatus')); ?></option>
                        <option value="1" <?php echo e(old('status') === '1' ? 'selected' : ''); ?>><?php echo e(__('main::lang.active')); ?></option>
                        <option value="0" <?php echo e(old('status') === '0' ? 'selected' : ''); ?>><?php echo e(__('main::lang.stopped')); ?></option>
                    </select>
                </div>
                <div class="form-group col-12 col-md-2 ">
                	<button type="submit" class="btn btn-primary btn-md"><i class="fa fa-search"></i></button>
                	<button type="button" class="btn btn-secondary btn-md search-reset"><i class="fa fa-ban"></i></button>
                </div>
              </div>
              <!-- /.row-->
            </form>
          </div>
        </div>

      </div>
      <h3><?php echo e(__('main::lang.customersCount')); ?> : <?php echo e($customersCount); ?></h3>
      	
        <div class="card d-none d-md-block">
          <div class="card-header">
          	<div class="row">
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.id')); ?></strong></div>
          		<div class="col-12 col-md-2 text-center"><strong><?php echo e(__('main::lang.customers_name')); ?></strong></div>
          		<div class="col-12 col-md-2 text-center"><strong><?php echo e(__('main::lang.customers_phone')); ?></strong></div>
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.store')); ?></strong></div>
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.gender')); ?></strong></div>
          		<div class="col-12 col-md-2 text-center"><strong><?php echo e(__('main::lang.email')); ?></strong></div>
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.status')); ?></strong></div>
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.created_at')); ?></strong></div>
          		<div class="col-12 col-md-1 "><strong><?php echo e(__('main::lang.actions')); ?></strong></div>
          	</div>
          </div>
        </div>

      	
		<?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
	        <div class="card">
	          <div class="card-body">
	          	<div class="row">
	          		<div class="col-xs-12 col-md-1 text-md-center">
                        <a href="<?php echo e(route('admin.customers.show', $customer->customers_id)); ?>" >
                            <div class="row mb-2 mb-md-0 h-100">
                                <div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.id')); ?></strong></div>
                                <div class="col-8 col-md-12"><?php echo e($customer->customers_id); ?></div>
                            </div>
                        </a>
	          		</div>
	          		<div class="col-12 col-md-2 text-md-center">
                  <a href="<?php echo e(route('admin.customers.show', $customer->customers_id)); ?>" >
                      <div class="row mb-2 mb-md-0 h-100">
                          <div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.customers_name')); ?></strong></div>
                          <div class="col-8 col-md-12"><?php echo e($customer->customers_name); ?></div>
                      </div>
                  </a>
	          		</div>

                <div class="col-12 col-md-2 text-md-center">
                    <div class="row mb-2 mb-md-0 h-100">
                        <div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.customers_phone')); ?></strong></div>
                        <div class="col-8 col-md-12" dir="ltr"><?php echo e($customer->customers_country_code); ?><?php echo e($customer->customers_phone); ?></div>
                    </div>
	          		</div>

                <div class="col-12 col-md-1 text-md-center">
                  <?php if($customer->country): ?>
                    <a href="<?php echo e(route('admin.countries.show', [$customer->countries_id, 'activeLocale' => $customerTrans->locale])); ?>">
                        <div class="row mb-2 mb-md-0 h-100">
                          <div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.country')); ?></strong></div>
                          <div class="col-8 col-md-12"><?php echo e($customer->country ? $customer->country->translate($customerTrans->locale)->countries_name : '--'); ?></div>
                        </div>
                    </a>
                  <?php endif; ?>
                </div>
 

	          		<div class="col-12 col-md-1 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.customers_gender')); ?></strong></div>
	          				<div class="col-8 col-md-12"  ><?php echo e($customer->customers_gender ? __('main::lang.'.$customer->customers_gender) : '--'); ?> </div>
	          			</div>
	          		</div>

	          		<div class="col-12 col-md-2 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.email')); ?></strong></div>
	          				<div class="col-8 col-md-12" dir="ltr"><?php echo e($customer->customers_email); ?></div>
	          			</div>
					      </div>

	          		<div class="col-12 col-md-1 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.status')); ?></strong></div>
	          				<div class="col-8 col-md-12">

                        <input type="checkbox" name="customers_status" id="customers_status_<?php echo e($customer->customers_id); ?>"  <?php echo e($customer->customers_status ? 'checked' : ''); ?>  data-on=" <?php echo e(__('main::lang.active')); ?>" data-off=" <?php echo e(__('main::lang.stopped')); ?>" data-toggle="toggle" data-onstyle="success" data-offstyle="danger" data-size="sm" onChange="changeStatus('<?php echo e($customer->customers_id); ?>')">

	          				</div>
	          			</div>
	          		</div>
                <div class="col-12 col-md-1 text-md-center">
                    <div class="row mb-2 mb-md-0">
                        <div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.created_at')); ?></strong></div>
                        <div class="col-8 col-md-12"><?php echo e($customer->customers_created_at->format('Y-m-d')); ?></div>
                    </div>
                </div>
               
	          		<div class="col-12 col-md-1  ">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.actions')); ?></strong></div>
	          				<div class="col-8 col-md-12">
	          					<form method="POST" action="<?php echo e(route('admin.customers.destroy', $customer->customers_id)); ?>">
	          						<?php echo csrf_field(); ?>
	          						<?php echo method_field('DELETE'); ?>
	          						
	          						<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update customers')): ?>
			          					<a href="<?php echo e(route('admin.customers.edit', $customer->customers_id)); ?>" class="btn btn-warning btn-md"><i class="fa fa-edit"></i></a>
	          						<?php endif; ?>
	          						<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete customers')): ?>

                                    <button type="submit" class="btn btn-danger btn-md delete-form">
                                        <i class="fa fa-trash"></i>
                                    </button>

	          						<?php endif; ?>
	          					</form>
	          				</div>
	          			</div>
	          		</div>
	          	</div>
	          </div>
	        </div>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
	        <div class="card">
	          <div class="card-body text-center text-danger">
	          	<?php echo e(__('main::lang.noData')); ?>

	          </div>
	        </div>
		<?php endif; ?>

				<?php echo e($customers->appends(request()->except('page'))->links()); ?>

      </div>
    </div>
  </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>

    <script>
        function changeStatus(id){
            console.log(document.getElementById('customers_status_'+id).checked);
            if(document.getElementById('customers_status_'+id).checked){
                status = '1';
            }else{
                status = '0';
            }
            $.ajax({
                type: "GET",
                url: "<?php echo url('/')?>/<?php echo e($locale); ?>/admin/customers/changeStatus/"+id+"/"+status,
                data: {
                    '_token': $('input[name=_token]').val(),
                    'device_token': "<?php echo e(isset($device_token) ? $device_token : ''); ?>",
                },
                success: function(data) {
                    $('#generalModalCenter').find('.modal-title').html(data.msg)
                    // $('#generalModalCenter').find('.modal-body').html(data.msg)
                    $('#generalModalCenter').modal('show')
                }
            })

        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('general::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/customers/index.blade.php ENDPATH**/ ?>