<?php $__env->startSection('main'); ?>
  <main class="main">
    <!-- Breadcrumb-->
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><?php echo e(__('main::lang.home')); ?></li>
      <li class="breadcrumb-item"><?php echo e(__('main::lang.customers')); ?></li>
      <li class="breadcrumb-item">
        <a href="<?php echo e(route('admin.customers_notifications.index')); ?>"><?php echo e(__('main::lang.customers_notifications')); ?></a>
      </li>
      <li class="breadcrumb-item  active"><?php echo e(__('main::lang.show')); ?></li>
    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
        <div class="card">
          <div class="card-header">
            <i class="fa fa-align-justify"></i> <?php echo e(__('main::lang.show')); ?>

          </div>
          <div class="card-body">
            <ul class="list-group">
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.message')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo e($customer_notification->customers_notifications_text); ?></div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('general::lang.admin')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo e($customer_notification->admin ? $customer_notification->admin->name : ''); ?></div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.type')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php if($customer_notification->customers_notifications_type == 'all'): ?>
                      <span class="badge badge-success"><?php echo e(__('main::lang.allCustomers')); ?></span>
                    <?php else: ?>
                      <span class="badge badge-secondary"><?php echo e(__('main::lang.someCustomers')); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.action_type')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php if($customer_notification->customers_notifications_action == 'url'): ?>
                      <span class="badge badge-success"><?php echo e(__('main::lang.url')); ?></span>
                    <?php else: ?>
                      <span class="badge badge-secondary"><?php echo e(__('main::lang.deep_link')); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.url')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php if($customer_notification->customers_notifications_action == 'url'): ?>
                      <?php echo e($customer_notification->customers_notifications_action_value); ?>

                    <?php else: ?>
                      <?php echo e($customer_notification->store ? $customer_notification->store->stores_name : ''); ?>

                    <?php endif; ?>
                  </div>
                </div>
              </li>

              
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.date')); ?></strong></div>
                  <div class="col-12 col-md-10"><?php echo e($customer_notification->customers_notifications_created_at->format('Y-m-d')); ?></div>
                </div>
              </li>
              <li class="list-group-item <?php echo e($customer_notification->customers_notifications_type == 'all' ? 'd-none' : ''); ?>">
                <div class="row">
                  <div class="col-12 col-md-2"><strong><?php echo e(__('main::lang.customers')); ?></strong></div>
                  <div class="col-12 col-md-10">
                    <?php $__currentLoopData = $customer_notification->customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('admin.customers.show',$customer->customers_id)); ?>"> <span class="badge badge-success"> <?php echo e($customer->customers_name); ?> </span> </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
              </li>
            </ul>
          </div>
          <div class="card-footer">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin.customers_notifications.index')): ?>
              <a href="<?php echo e(route('admin.customers_notifications.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="fa fa-arrow-left"></i>
              </a>
            <?php endif; ?>

          </div>
        </div>
      </div>
    </div>
  </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('general::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/customers_notifications/show.blade.php ENDPATH**/ ?>