<?php $__env->startSection('main'); ?>
  <main class="main">
  	
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><?php echo e(__('main::lang.home')); ?></li>
      <li class="breadcrumb-item"><?php echo e(__('main::lang.customers')); ?></li>
      <li class="breadcrumb-item  active"><?php echo e(__('main::lang.customers_notifications')); ?></li>

    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
      	<?php echo $__env->make('general::layouts.includes.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      	
        <div class="card">
          <div class="card-body">
            <form class="form-horizontal" action="<?php echo e(route('admin.customers_notifications.index')); ?>" method="get">

              <div class="row">
                <div class="form-group col-12 col-md-1 text-center">
					<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create customers_notifications')): ?>
						<a href="<?php echo e(route('admin.customers_notifications.create')); ?>" class="btn btn-success btn-md"><i class="fa fa-plus"></i></a>
					<?php endif; ?>
                </div>

				<div class="form-group col-12 col-md-3 text-center">
					<select class="form-control" name="pattern">
					  <option value=""><?php echo e(__('main::lang.pattern')); ?></option>
					  <option value="push" <?php echo e(old('pattern') === 'push' ? 'selected' : ''); ?>><?php echo e(__('main::lang.push')); ?></option>
					  <option value="in_app" <?php echo e(old('pattern') === 'in_app' ? 'selected' : ''); ?>><?php echo e(__('main::lang.in_app')); ?></option>
					</select>
				  </div>

                <div class="form-group col-12 col-md-3 text-center">
                  <input class="form-control" type="text" name="text" placeholder="<?php echo e(__('main::lang.message')); ?>" value="<?php echo e(old('text')); ?>">
                </div>

                <div class="form-group col-12 col-md-3 text-center">
			      <select class="form-control" name="type">
			        <option value=""><?php echo e(__('main::lang.type')); ?></option>
			        <option value="all" <?php echo e(old('type') === 'all' ? 'selected' : ''); ?>><?php echo e(__('main::lang.allCustomers')); ?></option>
			        <option value="some" <?php echo e(old('type') === 'some' ? 'selected' : ''); ?>><?php echo e(__('main::lang.someCustomers')); ?></option>
			        <option value="country" <?php echo e(old('type') === 'country' ? 'selected' : ''); ?>><?php echo e(__('main::lang.country')); ?></option>
			        <option value="gender" <?php echo e(old('type') === 'gender' ? 'selected' : ''); ?>><?php echo e(__('main::lang.gender')); ?></option>
			      </select>
                </div>

                <div class="form-group col-12 col-md-2  ">
                	<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i></button>
                	<button type="button" class="btn btn-secondary btn-sm search-reset"><i class="fa fa-ban"></i></button>
                </div>
              </div>
              <!-- /.row-->
            </form>
          </div>
        </div>

      	
        <div class="card d-none d-md-block">
          <div class="card-header">
          	<div class="row">
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.pattern')); ?></strong></div>
          		<div class="col-12 col-md-2 text-center"><strong><?php echo e(__('main::lang.title')); ?></strong></div>
          		<div class="col-12 col-md-2 text-center"><strong><?php echo e(__('main::lang.text')); ?></strong></div>
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('general::lang.admin')); ?></strong></div>
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.type')); ?></strong></div>
          		<div class="col-12 col-md-1 text-center"><strong><?php echo e(__('main::lang.action_type')); ?></strong></div>
	          	<div class="col-12 col-md-2 text-center"><strong><?php echo e(__('main::lang.date')); ?></strong></div>
           		<div class="col-12 col-md-2  "><strong><?php echo e(__('main::lang.actions')); ?></strong></div>
          	</div>
          </div>
        </div>

      	
		<?php $__empty_1 = true; $__currentLoopData = $customers_notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
	        <div class="card">
	          <div class="card-body">
	          	<div class="row">

					<div class="col-12 col-md-1 text-md-center">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.pattern')); ?></strong></div>
							<div class="col-8 col-md-12"><?php echo e(__('main::lang.'.$notification->customers_notifications_pattern)); ?></div>
						</div>
					</div>

	          		<div class="col-12 col-md-2 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.title')); ?></strong></div>
	          				<div class="col-8 col-md-12"><?php echo e($locale == 'ar' ? $notification->customers_notifications_title_ar : $notification->customers_notifications_title_en); ?></div>
	          			</div>
	          		</div>

					<div class="col-12 col-md-2 text-md-center">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.text')); ?></strong></div>
							<div class="col-8 col-md-12"><?php echo e($locale == 'ar' ? $notification->customers_notifications_text_ar : $notification->customers_notifications_text_en); ?></div>
						</div>
					</div>

                    <div class="col-12 col-md-1 text-md-center">
                        <div class="row mb-2 mb-md-0">
                            <div class="col-4 d-block d-md-none"><strong><?php echo e(__('general::lang.admin')); ?></strong></div>
                            <div class="col-8 col-md-12"><?php echo e($notification->admin ? $notification->admin->name : ''); ?></div>
                        </div>
                    </div>

	          		<div class="col-12 col-md-1 text-md-center  ">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.action_type')); ?></strong></div>
	          				<div class="col-8 col-md-12">
	          					<?php if($notification->customers_notifications_action == 'url'): ?>
	          						<span class="badge badge-success"><?php echo e(__('main::lang.url')); ?></span>
	          					<?php else: ?>
	          						<span class="badge badge-secondary"><?php echo e(__('main::lang.deep_link')); ?></span>
	          					<?php endif; ?>
	          				</div>
	          			</div>
	          		</div>

					<div class="col-12 col-md-1 text-md-center  ">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.type')); ?></strong></div>
							<div class="col-8 col-md-12">
								<?php if($notification->customers_notifications_type == 'all'): ?>
									<span class="badge badge-success"><?php echo e(__('main::lang.allCustomers')); ?></span>
								<?php else: ?>
									<span class="badge badge-secondary"><?php echo e(__('main::lang.someCustomers')); ?></span>
								<?php endif; ?>
							</div>
						</div>
					</div>

	          		<div class="col-12 col-md-2 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.date')); ?></strong></div>
	          				<div class="col-8 col-md-12">
	          					<?php echo e($notification->customers_notifications_created_at->format('Y-m-d')); ?>

	          				</div>
	          			</div>
	          		</div>

	          		<div class="col-12 col-md-2">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong><?php echo e(__('main::lang.actions')); ?></strong></div>
	          				<div class="col-8 col-md-12">
							  	<a href="<?php echo e(route('admin.customers_notifications.show', $notification->customers_notifications_id)); ?>" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>

	          				</div>
	          			</div>
	          		</div>

	          	</div>
	          </div>
	        </div>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
	        <div class="card">
	          <div class="card-body text-center text-danger">
	          	<?php echo e(__('main::lang.noData')); ?>

	          </div>
	        </div>
		<?php endif; ?>

		<?php echo e($customers_notifications->appends(request()->query())->links()); ?>


      </div>
    </div>
  </main>
<?php $__env->stopSection(); ?>

 
<?php echo $__env->make('general::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vivacoupon/public_html/system.vivacoupon.com/system/Modules/Main/Resources/views/admin/customers_notifications/index.blade.php ENDPATH**/ ?>