@extends('general::layouts.master')

@section('main')
  <main class="main">

  	{{-- Breadcrumb Section --}}
    <ol class="breadcrumb">
      <li class="breadcrumb-item"> <a href="{{ route('admin.dashboard.home') }}">{{ __('general::lang.home') }} </a></li>
	  <li class="breadcrumb-item  active"> {{ __('main::lang.reports') }}</li>
	  <li class="breadcrumb-item  active"> {{ __('main::lang.stores') }}</li>
    </ol>
	{{-- end Breadcrumb Section --}}

    <div class="container-fluid">
      <div class="animated fadeIn">

      	{{-- Operations Messages --}}
      	@include('general::layouts.includes.messages')

       
        {{-- Search Section --}}
        <div class="card">
            <div class="card-body">
                <form class="form-horizontal" action="{{ route('admin.stores.reports') }}" method="get" id="formStoresSearch">
                    
                <input class="form-control px-0" id="form_type" type="hidden" name="form_type" value="search">
                <div class="row">
                    
                    <div class="form-group col-12 col-md-2 text-center">
                        <input class="form-control" type="text" name="name" placeholder="{{ __('main::lang.name') }}" value="{{ old('name') }}">
                    </div>
                    
                    <div class="form-group col-12 col-md-2 text-center">
                        <select class="form-control select2" name="countries[]" multiple placeholder="{{ __('main::lang.countries') }}">
                            @foreach ($countries as $key => $name)
                                <option value="{{$key}}" {{ is_array(old('countries')) && in_array($key,old('countries')) ? 'selected' : '' }}>{{ $name }}</option>  
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-12 col-md-2 text-center">
                        <select class="form-control select2" name="categories[]" multiple placeholder="{{ __('main::lang.categories') }}">
                            @foreach ($categories as $key => $name)
                            <option value="{{$key}}" {{ is_array(old('categories')) && in_array($key,old('categories')) ? 'selected' : '' }}>{{ $name }}</option>  
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-12 col-md-2 text-center">
                        <select class="form-control" name="is_special">
                            <option value="">{{ __('main::lang.is_special') }}</option>
                            <option value="1" {{ old('is_special') === '1' ? 'selected' : '' }}>{{ __('main::lang.special') }}</option>
                            <option value="0" {{ old('is_special') === '0' ? 'selected' : '' }}>{{ __('main::lang.not_special') }}</option>
                        </select>
                    </div>
 
                    <div class="form-group col-12 col-md-2 text-center">
                        <select class="form-control" name="status">
                            <option value="">{{ __('general::lang.selectStatus') }}</option>
                            <option value="1" {{ old('status') === '1' ? 'selected' : '' }}>{{ __('general::lang.active') }}</option>
                            <option value="0" {{ old('status') === '0' ? 'selected' : '' }}>{{ __('general::lang.stopped') }}</option>
                        </select>
                    </div>

                    <div class="form-group col-12 col-md-2">
                        <button type="submit" class="btn btn-primary btn-md"><i class="fa fa-search"></i></button>
                        <button type="button" class="btn btn-secondary btn-md search-reset"><i class="fa fa-ban"></i></button>
                        <button type="button" onclick="ExportStores();" class="btn btn-success btn-md"><i class="fa fa-file-excel-o"></i></button>

                    </div>
                </div>
                <!-- /.row-->
                </form>
            </div>
        </div>
        <h3>{{__('main::lang.storesCount')}} : {{$storesCount}}</h3>
      	{{-- Header Section --}}
        <div class="card d-none d-md-block">
          <div class="card-header">
          	<div class="row">
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.stores_code') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.stores_name') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.stores_link') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.stores_logo') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.coupons_count') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.countries') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.categories') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.is_special') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.status') }}</strong></div>
          	</div>
          </div>
        </div>

      	{{-- Data Section --}}
            @forelse ($stores as $store)
                @php
                    $f = true;
                @endphp
                <div class="card {{ $loop->even ? 'even-record' : '' }}">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xs-12 col-md-1 text-md-center">
                                @if ($f)
                                    <a href="{{ route('admin.stores.show', [$store->stores_id]) }}">
                                        <div class="row mb-2 mb-md-0">
                                            <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.stores_code') }}</strong></div>
                                            <div class="col-8 col-md-12">{{ $store->stores_code }}</div>
                                        </div>
                                    </a>
                                @endif
                            </div>

                            <div class="col-12 col-md-2 text-md-center">
                                @if ($f)
                                <a href="{{ route('admin.stores.show', [$store->stores_id]) }}">
                                    <div class="row mb-2 mb-md-0">
                                        <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.stores_name') }}</strong></div>
                                        <div class="col-8 col-md-12">{{ $store->stores_name }}</div>
                                    </div>
                                </a>
                                @endif
                            </div>

                            <div class="col-12 col-md-2 text-md-center">
                                @if ($f)
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.stores_link') }}</strong></div>
                                    <div class="col-8 col-md-12">
                                        <a href="{{ $store->stores_link }}" target="_blank">{{ $store->stores_link }}</a>
                                    </div>
                                </div>
                                @endif
                            </div>

                            <div class="col-12 col-md-1 text-md-center">
                                @if ($f)
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.stores_logo') }}</strong></div>
                                    <div class="col-8 col-md-12">
                                        <img src="{{ $store->stores_logo ? asset($store->images_url($store->stores_logo, 'thumbnail','stores')) : asset('assets/adminPanel/img/no-image.png') }}" class="img-fluid img-thumbnail" width="75px" height="75px" />
                                    </div>
                                </div>
                                @endif
                            </div>

                            <div class="col-12 col-md-1 text-md-center">
                                @if ($f)
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.coupons_count') }}</strong></div>
                                    <div class="col-8 col-md-12">{{ sizeof($store->coupons) }}</div>
                                </div>
                                @endif
                            </div>


                            <div class="col-12 col-md-1 text-md-center">
                                @if ($f)
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.countries') }}</strong></div>
                                    <div class="col-8 col-md-12">{{ sizeof($store->countries) }}</div>
                                </div>
                                @endif
                            </div>

                            <div class="col-12 col-md-1 text-md-center">
                                @if ($f)
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.categories') }}</strong></div>
                                    <div class="col-8 col-md-12">{{ sizeof($store->categories) }}</div>
                                </div>
                                @endif
                            </div>

                            <div class="col-12 col-md-1 text-md-center">
                                @if ($f)
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.is_special') }}</strong></div>
                                    <div class="col-8 col-md-12"> 
                                        @if ($store->stores_is_special == '1')
                                            <span class="badge badge-warning">{{ __('main::lang.yes') }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ __('main::lang.no') }}</span>
                                        @endif
                                    </div>
                                </div>
                                @endif
                            </div>

                            <div class="col-12 col-md-2 text-md-center">
                                @if ($f)
                                <div class="row mb-2 mb-md-0">
                                    <div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.status') }}</strong></div>
                                    <div class="col-8 col-md-12">

                                        @if ($store->stores_status == '1')
                                            <span class="badge badge-warning">{{ __('main::lang.active') }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ __('main::lang.stopped') }}</span>
                                        @endif
 
                                    </div>
                                </div>
                                @endif
                            </div>
                    
                        </div>
                    </div>
                </div>
                @php
                    $f = false;
                @endphp
			@empty
                <div class="card">
                <div class="card-body text-center text-danger">
                    {{ __('main::lang.noData') }}
                </div>
                </div>
            @endforelse

            {{ $stores->appends(request()->except('page'))->links() }}
      </div>
    </div>
  </main>
@endsection
@section('script')
<script>
	$('#buttun-imortStores').click(function(){
		$(".loader").show();
        $("#overlayer").show();
		$('#imortStores-form').submit();
	})


    function ExportStores(){
        $('#form_type').val('export') ;
        $('#formStoresSearch').submit();
        $('#form_type').val('search') ;
    }
</script>
@endsection
