@extends('general::layouts.master')

@section('main')
  <main class="main">
    <!-- Breadcrumb-->
    <ol class="breadcrumb">
      <li class="breadcrumb-item">{{ __('main::lang.home') }}</li>
      <li class="breadcrumb-item">{{ __('main::lang.customers') }}</li>
      <li class="breadcrumb-item">
        <a href="{{ route('admin.customers_notifications.index') }}">{{ __('main::lang.customers_notifications') }}</a>
      </li>
      <li class="breadcrumb-item  active">{{ __('main::lang.show') }}</li>
    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
        <div class="card">
          <div class="card-header">
            <i class="fa fa-align-justify"></i> {{ __('main::lang.show') }}
          </div>
          <div class="card-body">
            <ul class="list-group">
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.title_ar') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->customers_notifications_title_ar }}</div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.text_ar') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->customers_notifications_text_ar }}</div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.title_en') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->customers_notifications_title_en }}</div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.text_en') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->customers_notifications_text_en }}</div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('general::lang.admin') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->admin ? $customer_notification->admin->name : '' }}</div>
                </div>
              </li>
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.type') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @if ($customer_notification->customers_notifications_type == 'all')
                      <span class="badge badge-success">{{ __('main::lang.allCustomers') }}</span>
                    @elseif ($customer_notification->customers_notifications_type == 'country')
                      <span class="badge badge-success">{{ __('main::lang.country') }}</span>
                    @elseif ($customer_notification->customers_notifications_type == 'gender')
                      <span class="badge badge-success">{{ __('main::lang.gender') }}</span>
                    @else
                      <span class="badge badge-secondary">{{ __('main::lang.someCustomers') }}</span>
                    @endif
                  </div>
                </div>
              </li>
              @if($customer_notification->customers_notifications_type == 'country')
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.country') }}</strong></div>
                  <div class="col-12 col-md-10">
                    {{$customer_notification->country ? $customer_notification->country->countries_name : '--'}}
                  </div>
                </div>
              </li>
              @endif

              @if($customer_notification->customers_notifications_type == 'gender')
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.gender') }}</strong></div>
                  <div class="col-12 col-md-10">
                    {{$customer_notification->customers_gender ? __('main::lang.'.$customer_notification->customers_gender) : '--'}}
                  </div>
                </div>
              </li>
              @endif
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.action_type') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @if ($customer_notification->customers_notifications_action == 'url')
                      <span class="badge badge-success">{{ __('main::lang.url') }}</span>
                    @else
                      <span class="badge badge-secondary">{{ __('main::lang.deep_link') }}</span>
                    @endif
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.url') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @if ($customer_notification->customers_notifications_action == 'url')
                      {{$customer_notification->customers_notifications_action_value}}
                    @else
                      {{$customer_notification->store ? $customer_notification->store->stores_name : ''}}
                    @endif
                  </div>
                </div>
              </li>

                
              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.image') }}</strong></div>
                  <div class="col-12 col-md-10">
                    <img onClick="window.open('{{ $customer_notification->customers_notifications_image ? asset($customer_notification->images_url($customer_notification->customers_notifications_image, 'original','notifications')) : asset('assets/adminPanel/img/no-image.png') }}', '_blank');" src="{{ $customer_notification->customers_notifications_image ? asset($customer_notification->images_url($customer_notification->customers_notifications_image, 'original','notifications')) : asset('assets/adminPanel/img/no-image.png') }}" width="300px" class="img-fluid img-thumbnail" />  
                  </div>
                </div>
              </li>

              <li class="list-group-item">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.date') }}</strong></div>
                  <div class="col-12 col-md-10">{{ $customer_notification->customers_notifications_created_at->format('Y-m-d') }}</div>
                </div>
              </li>
              
              <li class="list-group-item {{$customer_notification->customers_notifications_type == 'some' ? '' : 'd-none'}}">
                <div class="row">
                  <div class="col-12 col-md-2"><strong>{{ __('main::lang.customers') }}</strong></div>
                  <div class="col-12 col-md-10">
                    @foreach($customer_notification->customers as $customer)
                    <a href="{{route('admin.customers.show',$customer->customers_id)}}"> <span class="badge badge-success"> {{$customer->customers_name}} </span> </a>
                    @endforeach
                  </div>
                </div>
              </li>
              
            </ul>
          </div>
          <div class="card-footer">
            @can('admin.customers_notifications.index')
              <a href="{{ route('admin.customers_notifications.index') }}" class="btn btn-sm btn-secondary">
                <i class="fa fa-arrow-left"></i>
              </a>
            @endcan

          </div>
        </div>
      </div>
    </div>
  </main>
@endsection
