@extends('general::layouts.master')

@section('main')
  <main class="main">
  	{{-- Breadcrumb Section --}}
    <ol class="breadcrumb">
      <li class="breadcrumb-item">{{ __('main::lang.home') }}</li>
      <li class="breadcrumb-item">{{ __('main::lang.customers') }}</li>
      <li class="breadcrumb-item  active">{{ __('main::lang.customers_notifications') }}</li>

    </ol>
    <div class="container-fluid">
      <div class="animated fadeIn">
      	@include('general::layouts.includes.messages')

      	{{-- Search Section --}}
        <div class="card">
          <div class="card-body">
            <form class="form-horizontal" action="{{ route('admin.customers_notifications.index') }}" method="get">

              <div class="row">
                <div class="form-group col-12 col-md-1 text-center">
					@can('create customers_notifications')
						<a href="{{ route('admin.customers_notifications.create') }}" class="btn btn-success btn-md"><i class="fa fa-plus"></i></a>
					@endcan
                </div>

				<div class="form-group col-12 col-md-3 text-center">
					<select class="form-control" name="pattern">
					  <option value="">{{ __('main::lang.pattern') }}</option>
					  <option value="push" {{ old('pattern') === 'push' ? 'selected' : '' }}>{{ __('main::lang.push') }}</option>
					  <option value="in_app" {{ old('pattern') === 'in_app' ? 'selected' : '' }}>{{ __('main::lang.in_app') }}</option>
					</select>
				  </div>

                <div class="form-group col-12 col-md-3 text-center">
                  <input class="form-control" type="text" name="text" placeholder="{{ __('main::lang.message') }}" value="{{ old('text') }}">
                </div>

                <div class="form-group col-12 col-md-3 text-center">
			      <select class="form-control" name="type">
			        <option value="">{{ __('main::lang.type') }}</option>
			        <option value="all" {{ old('type') === 'all' ? 'selected' : '' }}>{{ __('main::lang.allCustomers') }}</option>
			        <option value="some" {{ old('type') === 'some' ? 'selected' : '' }}>{{ __('main::lang.someCustomers') }}</option>
			        <option value="country" {{ old('type') === 'country' ? 'selected' : '' }}>{{ __('main::lang.country') }}</option>
			        <option value="gender" {{ old('type') === 'gender' ? 'selected' : '' }}>{{ __('main::lang.gender') }}</option>
			      </select>
                </div>

                <div class="form-group col-12 col-md-2  ">
                	<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i></button>
                	<button type="button" class="btn btn-secondary btn-sm search-reset"><i class="fa fa-ban"></i></button>
                </div>
              </div>
              <!-- /.row-->
            </form>
          </div>
        </div>

      	{{-- Header Section --}}
        <div class="card d-none d-md-block">
          <div class="card-header">
          	<div class="row">
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.pattern') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.title') }}</strong></div>
          		<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.text') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('general::lang.admin') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.type') }}</strong></div>
          		<div class="col-12 col-md-1 text-center"><strong>{{ __('main::lang.action_type') }}</strong></div>
	          	<div class="col-12 col-md-2 text-center"><strong>{{ __('main::lang.date') }}</strong></div>
           		<div class="col-12 col-md-2  "><strong>{{ __('main::lang.actions') }}</strong></div>
          	</div>
          </div>
        </div>

      	{{-- Data Section --}}
		@forelse ($customers_notifications as $notification)
	        <div class="card">
	          <div class="card-body">
	          	<div class="row">

					<div class="col-12 col-md-1 text-md-center">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.pattern') }}</strong></div>
							<div class="col-8 col-md-12">{{ __('main::lang.'.$notification->customers_notifications_pattern) }}</div>
						</div>
					</div>

	          		<div class="col-12 col-md-2 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.title') }}</strong></div>
	          				<div class="col-8 col-md-12">{{ $locale == 'ar' ? $notification->customers_notifications_title_ar : $notification->customers_notifications_title_en  }}</div>
	          			</div>
	          		</div>

					<div class="col-12 col-md-2 text-md-center">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.text') }}</strong></div>
							<div class="col-8 col-md-12">{{ $locale == 'ar' ? $notification->customers_notifications_text_ar : $notification->customers_notifications_text_en }}</div>
						</div>
					</div>

                    <div class="col-12 col-md-1 text-md-center">
                        <div class="row mb-2 mb-md-0">
                            <div class="col-4 d-block d-md-none"><strong>{{ __('general::lang.admin') }}</strong></div>
                            <div class="col-8 col-md-12">{{ $notification->admin ? $notification->admin->name : '' }}</div>
                        </div>
                    </div>

	          		<div class="col-12 col-md-1 text-md-center  ">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.action_type') }}</strong></div>
	          				<div class="col-8 col-md-12">
	          					@if ($notification->customers_notifications_action == 'url')
	          						<span class="badge badge-success">{{ __('main::lang.url') }}</span>
	          					@else
	          						<span class="badge badge-secondary">{{ __('main::lang.deep_link') }}</span>
	          					@endif
	          				</div>
	          			</div>
	          		</div>

					<div class="col-12 col-md-1 text-md-center  ">
						<div class="row mb-2 mb-md-0">
							<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.type') }}</strong></div>
							<div class="col-8 col-md-12">
								@if ($notification->customers_notifications_type == 'all')
									<span class="badge badge-success">{{ __('main::lang.allCustomers') }}</span>
								@else
									<span class="badge badge-secondary">{{ __('main::lang.someCustomers') }}</span>
								@endif
							</div>
						</div>
					</div>

	          		<div class="col-12 col-md-2 text-md-center">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.date') }}</strong></div>
	          				<div class="col-8 col-md-12">
	          					{{$notification->customers_notifications_created_at->format('Y-m-d')}}
	          				</div>
	          			</div>
	          		</div>

	          		<div class="col-12 col-md-2">
	          			<div class="row mb-2 mb-md-0">
	          				<div class="col-4 d-block d-md-none"><strong>{{ __('main::lang.actions') }}</strong></div>
	          				<div class="col-8 col-md-12">
							  	<a href="{{ route('admin.customers_notifications.show', $notification->customers_notifications_id) }}" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>

	          				</div>
	          			</div>
	          		</div>

	          	</div>
	          </div>
	        </div>
		@empty
	        <div class="card">
	          <div class="card-body text-center text-danger">
	          	{{ __('main::lang.noData') }}
	          </div>
	        </div>
		@endforelse

		{{ $customers_notifications->appends(request()->query())->links() }}

      </div>
    </div>
  </main>
@endsection

 