
@php
  $activeLocale = old('activeLocale', 'general');
  $activeLocale = 'general';
@endphp

<div class="card-body">
  @include('main::layouts.includes.messages')

  {{-- Tabs --}}
  <ul class="nav nav-tabs" id="langsTabs" role="tablist">
    <li class="nav-item">
      <a class="nav-link {{ $activeLocale == 'general' ? 'active' : '' }}" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
      {{ __('main::lang.general') }}</a>
    </li>
    @foreach ($langs as $lang)
      <li class="nav-item">
        <a class="nav-link {{ $activeLocale == $lang->locale ? 'active' : '' }}" id="{{ $lang->locale }}-tab" data-toggle="tab" href="#{{ $lang->locale }}"
          role="tab" aria-controls="{{ $lang->locale }}" aria-selected="false">
          {{ __('main::lang.'. $lang->locale) }}
        </a>
      </li>
    @endforeach
  </ul>

  {{-- Tabs Content --}}
  <div class="tab-content" id="langsTabsContent">
    <div class="tab-pane fade {{ $activeLocale == 'general' ? 'show active' : '' }}" id="general" role="tabpanel" aria-labelledby="general-tab">
      <div class="row">
        <div class="col-lg-9">

            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="currencies_code">{{ __('main::lang.code') }}<span class="text-danger"> *</span></label>
                <div class="col-md-10">
                  <input class="form-control {{ $errors->first('currencies_code') ? 'is-invalid' : '' }}" id="currencies_code" type="text" name="currencies_code"
                  placeholder="{{ __('main::lang.code') }}" value="{{ old('currencies_code', isset($currency) ? $currency->currencies_code : '') }}">
                  @if ($errors->first('currencies_code'))
                      <div class="invalid-feedback">{{ $errors->first('currencies_code') }}</div>
                  @endif
                </div>
            </div>

        </div>
      </div>
    </div>


    {{-- Languages Tabs --}}
    @foreach ($langs as $lang)
      <div class="tab-pane fade {{ $activeLocale == $lang->locale ? 'show active' : '' }}" id="{{ $lang->locale }}" role="tabpanel" aria-labelledby="{{ $lang->locale }}-tab">

        <div class="row">

          <div class="col-lg-9">
            <p class="text-primary h6">{{ __('main::lang.currencyDetails') }}</p>
            <div class="form-group row">
              <label class="col-md-2 col-form-label">{{ __('main::lang.name') }}<span class="text-danger"> *</span></label>

              <div class="col-md-10">
                <input class="form-control {{ $errors->first($lang->locale .'.currencies_name') ? 'is-invalid' : '' }}" type="text"
                 name="{{ $lang->locale .'[currencies_name]' }}" placeholder="{{ __('main::lang.name') }}"
                 value="{{ old($lang->locale .'.currencies_name', isset($currency) && $currency->translate($lang->locale)  ? $currency->translate($lang->locale)->currencies_name : '') }}">
                @if ($errors->first($lang->locale .'.currencies_name'))
                  <div class="invalid-feedback">{{ $errors->first($lang->locale .'.currencies_name') }}</div>
                @endif
              </div>
            </div>

          </div>

        </div>



      </div>
    @endforeach


  </div>
</div>
