<?php

namespace Modules\Main\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\General\Models\StorageHandle;
use Modules\Main\Models\Customer;
use Carbon\Carbon;
class CustomerNotification extends Model
{
    use StorageHandle;
    protected $connection = 'mysql';
    /**
     * Table name.
     *
     * @var string
     */
    protected $table = 'customers_notifications';

    /**
     * Primary key.
     *
     * @var string
     */
    protected $primaryKey = 'customers_notifications_id';

    /**
     * Timestamps.
     *
     * @var string
     */
    const CREATED_AT = 'customers_notifications_created_at';
    const UPDATED_AT = 'customers_notifications_updated_at';

    /**
     * Fillable fields.
     *
     * @var array
     */
    protected $fillable = [
       'admins_id','customers_notifications_pattern','customers_notifications_title_en','customers_notifications_text_en','customers_notifications_title_ar','customers_notifications_text_ar','customers_notifications_image','customers_notifications_action','customers_notifications_action_value','customers_notifications_type','customers_notifications_customers','countries_id','customers_gender'
    ];


    /**
     * Set services's image.
     *
     * @param string $file
     */
    public function setCustomersNotificationsImageAttribute($file)
    {

        if ($file) {
            if (is_string($file)) {
                $this->attributes['customers_notifications_image'] = $file;
            } else {
                $current_name = $this->currentName($file);

                $this->originalImage($file, $current_name,'notifications');
                $this->mediumImage($file, $current_name,null,400,'notifications');
                $this->thumbImage($file, $current_name,100,null,'notifications');

                $this->attributes['customers_notifications_image'] = $current_name;
            }
        } else {
            $this->attributes['customers_notifications_image'] = null;
        }
    }

    public function getImageUrlAttribute($file)
    {
        if($this->customers_notifications_image){
            return asset('uploads/notifications/original/'.$this->customers_notifications_image) ;
        } 
        return null ;
    }
    /**
     * Scope a query to order data.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param string $type    ['asc', 'desc']
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeSorted($query, $type='asc')
    {
        return $query->orderBy('customers_notifications.customers_notifications_id', $type);
    }

    /**
     * Many to one relation with customers.
     *
     * @return collection of customer
     */
    public function getCustomersAttribute()
    {
        return Customer::whereIn('customers_id',explode(',',$this->customers_notifications_customers))->get();
        // return $this->belongsTo('Modules\Main\Models\Customer', 'customers_id', 'customers_id');
    }

    /**
     * Many to one relation with admins.
     *
     * @return collection of admin
     */
    public function admin()
    {
        return $this->belongsTo('Modules\General\Models\Admin', 'admins_id', 'admins_id');
    }

    public function country()
    {
        return $this->belongsTo('Modules\Main\Models\Country', 'countries_id', 'countries_id');
    }

    public function store()
    {
        return $this->belongsTo('Modules\Main\Models\Store', 'customers_notifications_action_value', 'stores_id');
    }

}
