<?php

namespace Modules\Main\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Modules\Main\Http\Requests\StoreRequest;
use Modules\Main\Imports\StoresImport;
use Modules\Main\Exports\StoresExports;
use Spatie\Permission\Models\Role;
use Modules\Main\Models\Store;
use Modules\Main\Models\Category;
use Modules\Main\Models\Country;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use File;
use DB;
class StoresController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $searchArray = [
            'store_translations.stores_name'=> [request('name'), 'like'],
            'stores.stores_status'          => [request('status'), '='],
            'stores.stores_is_special' => [request('is_special'), '='],

        ];
        request()->flash();

        $query = Store::join('store_translations', 'stores.stores_id', 'store_translations.stores_id')
        ->groupBy('stores.stores_id');

        $searchQuery = $this->searchIndex($query, $searchArray);

        if(request('form_type') && request('form_type') == 'export'){
            $stores = $searchQuery->get();
            return (new StoresExports($stores))->download('stores.xlsx');
        }

        $stores = $searchQuery->paginate(env('PerPage'));
        $categories = Category::all()->pluck('categories_name','categories_id');
        $countries = Country::all()->pluck('countries_name','countries_id');

        return view('main::admin.stores.index', compact('stores','countries','categories'));
    }

    public function reports()
    {
        $searchArray = [
            'store_translations.stores_name'=> [request('name'), 'like'],
            'stores.stores_status'          => [request('status'), '='],
            'stores.stores_is_special' => [request('is_special'), '='],

        ];
        request()->flash();

        $query = Store::join('store_translations', 'stores.stores_id', 'store_translations.stores_id')
        ->groupBy('stores.stores_id');

        $searchQuery = $this->searchIndex($query, $searchArray);
        
        if(request('countries') && is_array(request('countries')) && sizeof(request('countries')) > 0 ){
            // dd(request('countries'));
            $searchQuery = $searchQuery->join('store_countries', 'stores.stores_id', 'store_countries.stores_id')->whereIn('countries_id',request('countries'));
        }

        if(request('categories') && is_array(request('categories')) && sizeof(request('categories')) > 0 ){
            $searchQuery = $searchQuery->join('store_categories', 'stores.stores_id', 'store_categories.stores_id')->whereIn('categories_id',request('categories'));
        }

        if(request('form_type') && request('form_type') == 'export'){
            $stores = $searchQuery->get();
            return (new StoresExports($stores))->download('stores.xlsx');
        }
        $storesCount =  $searchQuery->get()->count('stores_id');
        $stores = $searchQuery->paginate(env('PerPage'));
        $categories = Category::all()->pluck('categories_name','categories_id');
        $countries = Country::all()->pluck('countries_name','countries_id');

        return view('main::admin.stores.reports', compact('stores','countries','categories','storesCount'));
    }


    /**
    * @return \Illuminate\Support\Collection
    */
    public function export(Request $request)
    {
        $stores = [];
        return (new StoresExports($stores))->download('stores.xlsx');
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function import(Request $request)
    {
        $this->validate($request, [
            'file' => 'required|file',
        ]);
        $import =new StoresImport();
        Excel::import($import,request()->file('file'));

        // $rows = $import->getRowCount() ;
        // if(sizeof($rows) > 0){
        //     return back()->with('status', __('main::lang.importSuccessExcept'))->with('failed_errors',$rows);
        // }else{
            return back()->with('status', __('main::lang.importSuccess'));
        // }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::all()->pluck('categories_name','categories_id');
        $countries = Country::all()->pluck('countries_name','countries_id');
        return view('main::admin.stores.create', compact('categories','countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Modules\General\Http\Requests\AdminRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreRequest $request)
    {
        $store = Store::create($request->all());

        if(sizeof($request->categories) > 0){
            $store->categories()->sync($request->categories);
        }
        if(sizeof($request->countries) > 0){
            $store->countries()->sync($request->countries);
        }
        return redirect()->route('admin.stores.index')->with('status', __('main::lang.storeCreated'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \Modules\General\Models\Store  $store
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $store = Store::find($id);
        return view('main::admin.stores.show', compact('store'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \Modules\General\Models\Store  $store
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $store = Store::find($id);
        $categories = Category::all()->pluck('categories_name','categories_id');
        $countries = Country::all()->pluck('countries_name','countries_id');
        return view('main::admin.stores.edit', compact('store','categories','countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Modules\General\Http\Requests\AdminRequest  $request
     * @param  \Modules\General\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function update(StoreRequest $request, Store $store)
    {
        $store->update($request->all());
        $store->categories()->sync($request->categories);
        $store->countries()->sync($request->countries);
        return redirect()->route('admin.stores.index')->with('status', __('main::lang.storeUpdated'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \Modules\General\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $store = Store::find($id);
        $store->delete();
        return back()->with('status', __('main::lang.storeDeleted'));
    }

    public function changeStatus($id, $status)
    {
        $store = Store::find($id);
        if($store){
            $store->stores_status = $status ;
            $store->save();
        }
        return response(['msg' =>  __('main::lang.storeUpdated')], 200);
    }

}
