<?php

namespace Modules\Main\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Modules\Main\Models\Sponsor;
use Modules\Main\Models\Country;
use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;
class SponsorsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $searchArray = [
            'sponsors_name' => [request('name'), 'like'],
            'sponsors_email' => [request('email'), 'like'],
            'sponsors_phone' => [request('phone'), 'like'],
            'countries_id' => [request('country'), '=']
        ];

        request()->flash();
        $query = Sponsor::orderBy('sponsors_id','desc');

        $searchQuery = $this->searchIndex($query, $searchArray);

        $sponsors = $searchQuery->paginate(env('PerPage'));

        $countries  = Country::active()->get()->pluck('countries_name','countries_id') ;
 
        return view('main::admin.sponsors.index', compact('sponsors','countries'));
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        $sponsor = Sponsor::findOrFail($id);
        // dd($sponsor);
        return view('main::admin.sponsors.show', compact('sponsor'));
    }

    public function store(SponsorRequest $request)
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //return view('main::sections.customers.create');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \Modules\General\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request, Sponsor $sponsor)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(SponsorRequest $request, Sponsor $sponsor)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Sponsor $sponsor)
    {
        // $sponsor->delete();
        // return back()->with('status', __('main::lang.customerDeleted'));
    }

}
