<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomersNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql')->create('customers_notifications', function (Blueprint $table) {
            $table->bigIncrements('customers_notifications_id');
            $table->unsignedBigInteger('admins_id')->nullable() ;
            $table->string('customers_notifications_title',255)->nullable() ;
            $table->text('customers_notifications_text')->nullable() ;
            $table->string('customers_notifications_image',255)->nullable() ;
            $table->enum('customers_notifications_type',['all','some'])->default('all') ;
            $table->enum('customers_notifications_action',['url','deep_link'])->default('url') ;
            $table->string('customers_notifications_action_value',255)->nullable();
            $table->text('customers_notifications_customers')->nullable();

            $table->timestamp('customers_notifications_created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('customers_notifications_updated_at')->default(\DB::raw('CURRENT_TIMESTAMP'));

            $table->foreign('admins_id')->references('admins_id')->on('admins')->cascadeOnUpdate()->nullOnDelete();

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers_notifications');
    }
}
